<?php
require_once '../config/db.php';

try {
    // Get the user's role
    $stmt = $pdo->prepare("
        SELECT u.id, u.username, u.email, r.id as role_id, r.name as role_name
        FROM users u
        JOIN roles r ON u.role_id = r.id
        WHERE u.email = ?
    ");
    $stmt->execute(['admin@pos.com']);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo "User not found!\n";
        exit;
    }

    echo "User Information:\n";
    echo "ID: {$user['id']}\n";
    echo "Username: {$user['username']}\n";
    echo "Email: {$user['email']}\n";
    echo "Role: {$user['role_name']} (ID: {$user['role_id']})\n\n";

    // Check permissions directly in database
    $stmt = $pdo->prepare("
        SELECT p.name, p.description
        FROM role_permissions rp
        JOIN permissions p ON rp.permission_id = p.id
        WHERE rp.role_id = ?
        AND p.name IN ('view_settings', 'manage_settings')
    ");
    $stmt->execute([$user['role_id']]);
    
    echo "Direct Database Permissions:\n";
    $hasViewSettings = false;
    $hasManageSettings = false;
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "- {$row['name']}: {$row['description']}\n";
        if ($row['name'] === 'view_settings') $hasViewSettings = true;
        if ($row['name'] === 'manage_settings') $hasManageSettings = true;
    }

    if (!$hasViewSettings || !$hasManageSettings) {
        echo "\nMissing permissions detected. Adding missing permissions...\n";
        
        // Get permission IDs
        $stmt = $pdo->prepare("SELECT id, name FROM permissions WHERE name IN ('view_settings', 'manage_settings')");
        $stmt->execute();
        $permissions = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        
        // Add missing permissions
        foreach ($permissions as $name => $id) {
            if (($name === 'view_settings' && !$hasViewSettings) || 
                ($name === 'manage_settings' && !$hasManageSettings)) {
                $stmt = $pdo->prepare("INSERT IGNORE INTO role_permissions (role_id, permission_id) VALUES (?, ?)");
                $stmt->execute([$user['role_id'], $id]);
                echo "Added {$name} permission\n";
            }
        }
    }

    echo "\nPlease log out and log back in for changes to take effect.\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 